package com.hero.ui.dialog;

import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.WindowConstants;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.CompoundPower;
import com.hero.ui.SelectionList;
import com.hero.ui.widgets.PopupMessage;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class AvailablePowersDialog extends JDialog {

	private static final long serialVersionUID = 810658576813640608L;

	CompoundPower parent;

	SelectionList selectList;

	JButton selectBtn;

	JButton cancelBtn;

	JButton defineBtn;

	GenericObject selection;

	public AvailablePowersDialog(CompoundPower caller, JDialog owner) {
		super(owner, "Available Powers", true);
		parent = caller;
		setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		initWidgets();
		initListeners();
		layoutComponent();
		pack();
		setSize(400, 500);
		setLocationRelativeTo(owner);
	}

	private void initListeners() {
		cancelBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				setVisible(false);
			}
		});
		defineBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (selectList.getSelection() == null) {
					return;
				}
				GenericObject mod = selectList.getSelection();
				if (mod.getDefinition() == null) {
					return;
				}
				if (mod.getDefinition().trim().length() == 0) {
					return;
				}
				PopupMessage popup = PopupMessage.getInstance(HeroDesigner
						.getAppFrame(), defineBtn, mod.getDefinition(), false);
				popup.setVisible(true);
			}
		});
		selectList.addTreeSelectionListener(new TreeSelectionListener() {
			public void valueChanged(TreeSelectionEvent e) {
				if ((selectList.getSelection() != null)
						&& !(selectList.getSelection() instanceof com.hero.objects.List)) {
					selectBtn.setEnabled(true);
					GenericObject mod = selectList.getSelection();
					if ((mod.getDefinition() == null)
							|| (mod.getDefinition().trim().length() == 0)) {
						return;
					} else {
						defineBtn.setEnabled(true);
					}
				} else {
					selectBtn.setEnabled(false);
					defineBtn.setEnabled(false);
				}
			}
		});
		selectList.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				if (e.getClickCount() == 2) {
					selectBtn.doClick();
				}
			}
		});
		selectBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if ((selectList.getSelection() != null)
						&& !(selectList.getSelection() instanceof com.hero.objects.List)) {
					GenericObject mod = selectList.getSelection();
					mod = mod.clone();
					mod.setDisplayActiveCost(HeroDesigner.getInstance()
							.getPrefs().displayActivePoints());
					mod.setMainPower(parent);
					GenericDialog dialog = mod.getDialog(true, mod.isPower());
					dialog.setLocationRelativeTo(AvailablePowersDialog.this);
					dialog.setVisible(true);
					if (!dialog.okButtonClicked) {
						return;
					}
					parent.getPowers().add(mod);
					selection = mod;
					setVisible(false);
				}
			}
		});
	}

	private void initWidgets() {
		ArrayList<GenericObject> avail = new ArrayList<GenericObject>();
		for (int i = 0; i < HeroDesigner.getActiveTemplate().getPowers().size(); i++) {
			GenericObject mod = HeroDesigner.getActiveTemplate().getPowers()
					.get(i);
			if (!mod.getXMLID().equals("COMPOUNDPOWER")) {
				avail.add(mod);
			}
		}
		selectList = new SelectionList(avail);
		selectBtn = new JButton("Select");
		selectBtn.setEnabled(false);
		cancelBtn = new JButton("Cancel");
		defineBtn = new JButton("Define");
		defineBtn.setEnabled(false);
	}

	private void layoutComponent() {
		JPanel panel = new JPanel(new GridBagLayout());
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.weightx = 1;
		gbc.weighty = 1;
		gbc.anchor = GridBagConstraints.CENTER;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.gridwidth = 1;
		gbc.insets = new Insets(0, 0, 5, 0);
		panel.add(selectList.getTree(), gbc);
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.weightx = 0;
		gbc.gridwidth = 1;
		gbc.gridy++;
		gbc.weighty = 0;
		JPanel buttons = new JPanel(new FlowLayout(FlowLayout.CENTER));
		buttons.add(selectBtn);
		buttons.add(defineBtn);
		buttons.add(cancelBtn);
		buttons.setOpaque(false);
		panel.add(buttons, gbc);
		panel.setOpaque(true);
		setContentPane(panel);
	}
}